<?php
session_start();

// Jika sudah login, langsung ke dashboard
if (isset($_SESSION['username'])) {
    header("Location: dashboard.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Login</title>

<style>
/* (CSS kamu TIDAK saya ubah) */
body {
    margin: 0;
    padding: 0;
    font-family: Arial, sans-serif;
    background: linear-gradient(135deg, #4c6ef5, #15aabf);
    height: 100vh;
    display: flex;
    justify-content: center;
    align-items: center;
}
.login-box {
    background: #ffffff;
    width: 380px;
    padding: 40px;
    border-radius: 15px;
    box-shadow: 0 0 20px rgba(0,0,0,0.15);
    text-align: center;
    animation: fadeIn 0.5s ease-in-out;
}
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to   { opacity: 1; transform: translateY(0); }
}
h2 {
    margin-bottom: 25px;
    color: #333;
    font-size: 26px;
    font-weight: bold;
}
.input-group {
    width: 100%;
    margin-bottom: 20px;
    text-align: left;
}
.input-group label {
    font-size: 14px;
    font-weight: bold;
    color: #555;
}
.input-group input {
    width: 100%;
    padding: 12px;
    border: 2px solid #ddd;
    border-radius: 8px;
    margin-top: 5px;
    font-size: 15px;
    transition: 0.3s;
}
.input-group input:focus {
    border-color: #4c6ef5;
    outline: none;
    box-shadow: 0 0 5px rgba(76,110,245,0.3);
}
button {
    width: 100%;
    padding: 12px;
    background: #4c6ef5;
    border: none;
    border-radius: 8px;
    color: white;
    font-size: 16px;
    cursor: pointer;
    font-weight: bold;
    transition: 0.3s;
}
button:hover {
    background: #3b5bdb;
}
.error {
    margin-top: 15px;
    color: red;
    font-size: 14px;
}
</style>

</head>
<body>

<div class="login-box">
    <h2>Login Website</h2>

    <form action="proses_login.php" method="POST">
        <div class="input-group">
            <label>Username</label>
            <input type="text" name="username" required>
        </div>

        <div class="input-group">
            <label>Password</label>
            <input type="password" name="password" required>
        </div>

        <button type="submit">Login</button>

        <?php if (isset($_GET['error'])): ?>
            <div class="error">Username atau Password salah!</div>
        <?php endif; ?>
    </form>
</div>

</body>
</html>